/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.PatternItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CrafterNetworkNode
extends NetworkNode
implements ICraftingPatternContainer {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "crafter");
    private static final Component DEFAULT_NAME = new TranslatableComponent("gui.refinedstorage.crafter");
    private static final String NBT_DISPLAY_NAME = "DisplayName";
    private static final String NBT_UUID = "CrafterUuid";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_LOCKED = "Locked";
    private static final String NBT_WAS_POWERED = "WasPowered";
    private final List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED).addListener(new NetworkNodeInventoryListener(this));
    private boolean visited = false;
    private final BaseItemHandler patternsInventory = new BaseItemHandler(9){

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!((ItemStack)this.stacks.get(slot)).m_41619_()) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }.addValidator(new PatternItemValidator(this.level)).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading) {
            if (!this.level.f_46443_) {
                this.invalidate();
            }
            if (this.network != null) {
                this.network.getCraftingManager().invalidate();
            }
        }
    });
    private CrafterMode mode = CrafterMode.IGNORE;
    private boolean locked = false;
    private boolean wasPowered;
    @Nullable
    private Component displayName;
    @Nullable
    private UUID uuid = null;

    public CrafterNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    private void invalidate() {
        this.patterns.clear();
        for (int i = 0; i < this.patternsInventory.getSlots(); ++i) {
            ICraftingPattern pattern;
            ItemStack patternStack = this.patternsInventory.getStackInSlot(i);
            if (patternStack.m_41619_() || !(pattern = ((ICraftingPatternProvider)patternStack.m_41720_()).create(this.level, patternStack, this)).isValid()) continue;
            this.patterns.add(pattern);
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCrafter().getUsage() + this.upgrades.getEnergyUsage() + RS.SERVER_CONFIG.getCrafter().getPatternUsage() * this.patterns.size();
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.invalidate();
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET && this.level.m_46749_(this.pos)) {
            if (this.level.m_46753_(this.pos)) {
                this.wasPowered = true;
                this.markDirty();
            } else if (this.wasPowered) {
                this.wasPowered = false;
                this.locked = false;
                this.markDirty();
            }
        }
    }

    @Override
    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        network.getCraftingManager().invalidate();
    }

    @Override
    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }

    @Override
    public void onDirectionChanged(Direction direction) {
        super.onDirectionChanged(direction);
        if (this.network != null) {
            this.network.getCraftingManager().invalidate();
        }
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems(this.patternsInventory, 0, tag);
        this.invalidate();
        StackUtils.readItems(this.upgrades, 1, tag);
        if (tag.m_128441_(NBT_DISPLAY_NAME)) {
            this.displayName = Component.Serializer.m_130701_((String)tag.m_128461_(NBT_DISPLAY_NAME));
        }
        if (tag.m_128403_(NBT_UUID)) {
            this.uuid = tag.m_128342_(NBT_UUID);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = CrafterMode.getById(tag.m_128451_(NBT_MODE));
        }
        if (tag.m_128441_(NBT_LOCKED)) {
            this.locked = tag.m_128471_(NBT_LOCKED);
        }
        if (tag.m_128441_(NBT_WAS_POWERED)) {
            this.wasPowered = tag.m_128471_(NBT_WAS_POWERED);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patternsInventory, 0, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        if (this.displayName != null) {
            tag.m_128359_(NBT_DISPLAY_NAME, Component.Serializer.m_130703_((Component)this.displayName));
        }
        if (this.uuid != null) {
            tag.m_128362_(NBT_UUID, this.uuid);
        }
        tag.m_128405_(NBT_MODE, this.mode.ordinal());
        tag.m_128379_(NBT_LOCKED, this.locked);
        tag.m_128379_(NBT_WAS_POWERED, this.wasPowered);
        return tag;
    }

    @Override
    public int getUpdateInterval() {
        switch (this.upgrades.getUpgradeCount(UpgradeItem.Type.SPEED)) {
            case 0: {
                return 10;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int getMaximumSuccessfulCraftingUpdates() {
        switch (this.upgrades.getUpgradeCount(UpgradeItem.Type.SPEED)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    @Override
    @Nullable
    public IItemHandler getConnectedInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return LevelUtils.getItemHandler(proxy.getFacingBlockEntity(), proxy.getDirection().m_122424_());
    }

    @Override
    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return LevelUtils.getFluidHandler(proxy.getFacingBlockEntity(), proxy.getDirection().m_122424_());
    }

    @Override
    @Nullable
    public BlockEntity getConnectedBlockEntity() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return proxy.getFacingBlockEntity();
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getPatternInventory() {
        return this.patternsInventory;
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.displayName;
    }

    @Override
    public Component getName() {
        Component displayNameOfRoot;
        ICraftingPatternContainer root = this.getRootContainer();
        if (root != null && (displayNameOfRoot = root.getCustomName()) != null) {
            return displayNameOfRoot;
        }
        BlockEntity facing = this.getConnectedBlockEntity();
        if (facing instanceof Nameable && ((Nameable)facing).m_7755_() != null) {
            return ((Nameable)facing).m_7755_();
        }
        if (facing != null) {
            return new TranslatableComponent(this.level.m_8055_(facing.m_58899_()).m_60734_().m_7705_());
        }
        return DEFAULT_NAME;
    }

    @Nullable
    public Component getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    public CrafterMode getMode() {
        return this.mode;
    }

    public void setMode(CrafterMode mode) {
        this.mode = mode;
        this.wasPowered = false;
        this.locked = false;
        this.markDirty();
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patternsInventory, this.upgrades});
    }

    @Override
    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        if (this.visited) {
            return null;
        }
        INetworkNode facing = API.instance().getNetworkNodeManager((ServerLevel)this.level).getNode(this.pos.m_142300_(this.getDirection()));
        if (!(facing instanceof ICraftingPatternContainer) || facing.getNetwork() != this.network) {
            return this;
        }
        this.visited = true;
        ICraftingPatternContainer facingContainer = ((ICraftingPatternContainer)((Object)facing)).getRootContainer();
        this.visited = false;
        return facingContainer;
    }

    public Optional<ICraftingPatternContainer> getRootContainerNotSelf() {
        ICraftingPatternContainer root = this.getRootContainer();
        if (root != null && root != this) {
            return Optional.of(root);
        }
        return Optional.empty();
    }

    @Override
    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    @Override
    public boolean isLocked() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            return root.get().isLocked();
        }
        switch (this.mode) {
            case IGNORE: {
                return false;
            }
            case SIGNAL_LOCKS_AUTOCRAFTING: {
                return this.level.m_46753_(this.pos);
            }
            case SIGNAL_UNLOCKS_AUTOCRAFTING: {
                return !this.level.m_46753_(this.pos);
            }
            case PULSE_INSERTS_NEXT_SET: {
                return this.locked;
            }
        }
        return false;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public void onUsedForProcessing() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            root.get().onUsedForProcessing();
            return;
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            this.locked = true;
            this.markDirty();
        }
    }

    public static enum CrafterMode {
        IGNORE,
        SIGNAL_UNLOCKS_AUTOCRAFTING,
        SIGNAL_LOCKS_AUTOCRAFTING,
        PULSE_INSERTS_NEXT_SET;


        public static CrafterMode getById(int id) {
            if (id >= 0 && id < CrafterMode.values().length) {
                return CrafterMode.values()[id];
            }
            return IGNORE;
        }
    }
}

